<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*//** */
 
require_once APPPATH.'libraries/DaaS_REST_Controller.php';
require_once APPPATH.'models/mailbox.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Directory_controller extends DaaS_REST_Controller{	
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();
		
		$this->load->model('facilitymodel');
	}
	
	public function addresses_get(){
		
		$search = $this->get('search');	
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		
		if($ldap_conn) {
			$account_query_string = "";
			$group_query_string = "";
			if ($search && $search!="") {
				$facilities = $this->facilitymodel->get_facilities_by_name($search)->result();
				if (!is_null($facilities)) {
					foreach($facilities as $facility) {
						$facility_id = $facility->id;
						$mailboxes = Mailbox::find(array('facility_id'=>$facility_id));
						foreach ($mailboxes as $mailbox){
							if($mailbox->is_group){
								$group_query_string = $group_query_string . '(ou=' . $mailbox->name . ')';
							}
							else{
								$account_query_string = $account_query_string . '(uid=' . $mailbox->name . ')';
							}
							
						}
					}
				}
			}
			$account_dn = LDAP_ACCOUNT_GROUP;
			$group_dn = LDAP_GROUPS_GROUP;
			$search = $this->ldap_escape($search);
			$properties = array('displayname','mail','uid','givenname','initials','sn','physicaldeliveryofficename','o','departmentnumber','mobile','telephonenumber','title','cn');
			$filter="(&(ObjectClass=person)(|(displayName=" . $search . "*)(mail=" . $search . "*)(mobile=" . $search . "*)(telephoneNumber=" . $search . "*)(givenName=" . $search . "*)(cn=" . $search . "*)" . $account_query_string . "))";
			$result_arr = array();
			$sr = @ldap_search($ldap_conn, $account_dn, $filter, $properties, NULL, $size_limit);
			if($sr === FALSE) {
				$this->response('Search Failed due to Internal Error.', 500);
			}
			else {
				ldap_sort($ldap_conn, $sr, 'displayname');
				$info = ldap_get_entries($ldap_conn, $sr);
				for($i = 0; $i < $info["count"]; $i++) {
					$result = array();
					foreach ($properties as $property){
						if(isset($info[$i][$property]) && isset($info[$i][$property][0])){
							$result[$property] = htmlentities($info[$i][$property][0]);
						}
					}
					//add facility information
					$mailbox = Mailbox::find_one( array('name'=>$result['uid'], 'is_group'=>false) );
					if(Mailbox::is_an_entity($mailbox)){
						$facility_id = $mailbox->facility_id;
						if(!is_null($facility_id)){
							$facility_name = $this->facilitymodel->get_facility($facility_id)->row_array(0)['name'];
							$result['facility'] = htmlentities($facility_name);
						}
					}
					$result_arr[] = $result;
				}
			}
			//Find groups
			$properties = array("cn","mail","ou");
			$filter="(&(ObjectClass=groupOfNames)(|(ou=" . $search . "*)(mail=" . $search . "*)(cn=" . $search . "*)" . $group_query_string . "))";
			$sr = @ldap_search($ldap_conn, $group_dn, $filter, $properties);
			if($sr === FALSE) {
				$this->response('Search Failed due to Internal Error.', 500);
			}
			else {
				ldap_sort($ldap_conn, $sr, 'cn');
				$info = ldap_get_entries($ldap_conn, $sr);
				for($i = 0; $i < $info["count"]; $i++) {
					$result = array();
					foreach ($properties as $property){
						if(isset($info[$i][$property]) && isset($info[$i][$property][0])){
							$result[$property] = htmlentities($info[$i][$property][0]);
						}
					}
					//add facility information
					$mailbox = Mailbox::find_one( array('name'=>$result['ou'], 'is_group'=>true) );
					if(Mailbox::is_an_entity($mailbox)){
						$facility_id = $mailbox->facility_id;
						if(!is_null($facility_id)){
							$facility_name = $this->facilitymodel->get_facility($facility_id)->row_array(0)['name'];
							$result['facility'] = htmlentities($facility_name);
						}
					}
					$result_arr[] = $result;
				}
			}
			usort($result_arr, function($a, $b) {
				if(isset($a['displayname'])){
					$a_name = $a['displayname'];
				}
				else{
					$a_name = $a['cn'];
				}
				if(isset($b['displayname'])){
					$b_name = $b['displayname'];
				}
				else{
					$b_name = $b['cn'];
				}
				return strnatcasecmp($a_name, $b_name);
			});
			
			$this->response_message['contacts'] = $result_arr;
			$this->response_message['count'] = count($result_arr);
			$this->response($this->response_message, 200);
		}
	}
	
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
	private function ldap_escape ($str = '') {
		$metaChars = array ("\\00", "\\", "(", ")");
		$quotedMetaChars = array ();
		foreach ($metaChars as $key => $value) {
			$quotedMetaChars[$key] = '\\'. dechex (ord ($value));
		}
		$str = str_replace (
				$metaChars, $quotedMetaChars, $str
		); //replace them
		return ($str);
	}
	
}
?>